<?php

/**
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 * @property CI_DB_active_record $db Description
 */
class Customer_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }
  
    public function checkUserActive($user_code) {
        $this->db->where(array('user_code' => $user_code, 'is_active' => 0));
        return $this->db->get('customer')->result_array();
    }

    public function checkUserHaveChiledCurrentMoth($id) {
         $this->db->where("DATE_FORMAT(  `join_date` ,  '%Y-%m' )='".date('Y-m')."'");
        $this->db->where("parent_id",$id);
        $kk = $this->db->get('customer')->result_array();
        
//        echo $this->db->last_query();
//        exit;
        return $kk;
    }
    public function getProductsByname($name) {
        $this->db->where(array('name' => $name, 'is_active' => 1));
        return $this->db->get('products')->result_array();
    }
    public function getProductsByValue($val) {
        $this->db->where(array('actual_amount' => $val, 'is_active' => 1));
        return $this->db->get('products')->result_array();
    }

    public function authenticationFailedTracking($ip, $use_code, $attempType) {
        $data = array(
            "ip" => $ip,
            "access_name" => $use_code,
            "date" => date('Y-m-d H:i:s'),
            "attempt_type" => $attempType
        );
        $this->db->insert('authentication_failed_tracking', $data);
    }

    public function checkOldEmail($user_id, $oldEmail) {
        $this->db->where(array('user_code' => $user_id, 'email' => $oldEmail));
        return $this->db->get('customer')->result_array();
//          echo $this->db->last_query();
//          exit;
    }

    public function genrateVoucher($data) {
        $this->db->insert("vouchers", $data);
    }

    public function updateUserEmail($user_id, $newEmail) {
        $this->db->where('user_code', $user_id);
        $this->db->update('customer', array('email' => $newEmail));
    }

    public function checkOldPassword($user_id, $oldPassword) {
        $this->db->where(array('user_code' => $user_id, 'password' => $oldPassword));
        return $this->db->get('customer')->result_array();
//          echo $this->db->last_query();
//          exit;
    }

    public function updateUserPassword($user_id, $newPassword) {
        $this->db->where('user_code', $user_id);
        $this->db->update('customer', array('password' => $newPassword));
    }

    public function checkOldPin($user_id, $oldPin) {
        $this->db->where(array('user_code' => $user_id, 'pin' => $oldPin));
        return $this->db->get('customer')->result_array();
    }

    public function updateUserPin($user_id, $newPin) {
        $this->db->where('user_code', $user_id);
        $this->db->update('customer', array('pin' => $newPin));
    }

    public function checkIdExist($user_code) {
        $this->db->where('user_code', $user_code);
        return $this->db->get('customer')->result_array();
//        echo $this->db->last_query();
//        exit;
    }

    public function blockUserByCode($id) {
        $this->db->where('user_code', $id);
        $this->db->update('customer', array('is_expire' => 1));
    }

    public function createNewUser($data) {

        $this->db->insert('customer', $data);
        return $this->db->insert_id();
    }

    public function loginInfo($loginId, $password) {
        $this->db->where(array('user_code' => $loginId, 'password' => $password));
        return $this->db->get('customer')->result_array();
    }

    public function createBonusAuditLog($data) {

        $this->db->insert('bonus_audit_log', $data);
        return $this->db->insert_id();
    }
    public function createAuditLog($data) {

        $this->db->insert('audit_log', $data);
        return $this->db->insert_id();
    }

    public function createPaymentLog($data) {

        $this->db->insert('payment_log', $data);
        return $this->db->insert_id();
    }

    public function getPaymentLogByUserid($id) {
        $this->db->where('user_id', $id);
        $this->db->order_by("payment_id", "asc");
        return $this->db->get('payment_log')->result_array();
    }

    public function getAccountStatementCountByUserId($id) {
        $this->db->where('user_id', $id);
        return count($this->db->get('payment_log')->result_array());
    }

    public function getAccountStatementByUserId($id, $limit, $start) {
        $this->db->where('user_id', $id);
        $this->db->limit($limit, $start);
//        $this->db->select_sum('amount');
        $this->db->order_by("payment_id", "asc");
        return $this->db->get('payment_log')->result_array();
//        echo $this->db->last_query();
//        exit
    }

    public function getAccountStatementSumByUserId($id, $limit, $start) {
        echo $query = "SELECT sum( amount ) as balance FROM payment_log WHERE user_id = " . $id . " LIMIT " . $start . ", " . $limit . "";

        $sqlResult = $this->db->query($query)->result_array();
        return $sqlResult;
//        $this->db->where('user_id', $id);
//        $this->db->select_sum('sum( amount ) as balance');
//        $this->db->limit($limit, $start);
////        $this->db->select_sum('amount');
//        $this->db->group_by("payment_id");
//        $this->db->order_by("payment_id", "asc");
//        return $this->db->get('payment_log')->result_array();
//        echo $this->db->last_query();
//        exit
    }

    public function updateParentById($user_id, $data) {
        $this->db->where('user_code', $user_id);
        $this->db->update('customer', $data);
    }

    public function getUserExpire() {
//        $this->db->where('id',$user_id);
//        $this->db->get('parent_id',$id);

        $this->db->where('is_expire', 1);
        $this->db->where('user_code !=', '1');
        return $this->db->get('customer')->result_array();
    }

    public function CheckUserExpire() {
//        $this->db->where('id',$user_id);
//        $this->db->get('parent_id',$id);

        $this->db->where('is_expire', 0);
        $this->db->where('user_code > 2');
        return $this->db->get('customer')->result_array();
    }

    public function getAllUsers() {
        $this->db->where('user_code > 2');  
       return $this->db->get('customer')->result_array(); 
    }

    public function getUserTable($id) {
//        $this->db->where('id',$user_id);
//        $this->db->get('parent_id',$id);

        $this->db->where('parent_id', $id);
        return $this->db->get('customer')->result_array();
    }

    public function getUserByIdAndParentId($user_id, $parent_id) {
        $this->db->where(array('id' => $user_id, 'parent_id' => $parent_id));
        return $this->db->get('customer')->result_array();
    }

//
//    public function getUserByMonth($month = "", $filter_radio = "", $id = "", $startDate = "", $endDate = "") {
////        echo "$month";
//        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {
//            echo 'there';
//            exit;
//            $this->db->where('join_date>=', $startDate);
//            $this->db->where('join_date<=', $endDate);
//            $this->db->where('parent_id', $id);
//            $result = $this->db->get('customer')->result_array();
//            echo $this->db->last_query();
//            exit;
//            return $result;
//        } else if ($filter_radio == "monthlyReport" && $month == "all") {
//            $this->db->where('parent_id', $id);
//            return $this->db->get('customer')->result_array();
//        } else {
//            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
//            $this->db->where('parent_id', $id);
////           $this->db->where(array('DATE_FORMAT("join_date" ,"%Y-%m" )'=>  $month ,'parent_id'=>$id));
//            $result = $this->db->get('customer')->result_array();
////            echo $this->db->last_query(); // check last query execute
//            return $result;
//        }
//    }
    function getUserChildrens($id,$filter_radio = "", $month = "", $startDate = "", $endDate = "") {
         if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {
             
            $this->db->where('DATE_FORMAT(  `join_date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `join_date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
//            if($id !="")
//            {
//            $this->db->where('created_id', $id);
//            }
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {
//            echo $month;
//            exit;
            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
        }
        $this->db->where("parent_id", $id);
        $kk =  $this->db->get('customer')->result_array();
//     echo   $this->db->last_query();
     return $kk;
    }
    function getBonusQualifiers()
    {
        $this->db->where('depth_level >= 10');
        return $this->db->get('customer')->result_array();
        
    }
    function bonusMonthlyAchievers()
    {
        $this->db->where("depth_level >= 11");
        $this->db->where('DATE_FORMAT(  `join_date` ,  "%Y-%m-%d" ) =', date("Y-m-d", strtotime(date('Y-m-d'))));
        $kk = $this->db->get('customer')->result_array();
        echo   $this->db->last_query();
        return $kk;
    }

    public function getUserByCode($user_code) {
        $this->db->where('user_code', $user_code);
//        echo $this->db->last_query();
        return $this->db->get('customer')->result_array();
    }

    public function getUserByKey($key) {
        $this->db->where('data_key', $key);
//        echo $this->db->last_query();
        return $this->db->get('customer')->result_array();
    }

    public function getnameBycode($user_code) {
        $this->db->where('user_code', $user_code);
        $arr = $this->db->get('customer')->result_array();
        return isset($arr[0]['name']) ? $arr[0]['name'] : false;
        //return $this->db->get('customer')->result_array();
    }

    public function getnameByid($user_code) {
        $this->db->where('id', $user_code);
        $arr = $this->db->get('customer')->result_array();
        return isset($arr[0]['name']) ? $arr[0]['name'] : false;
        //return $this->db->get('customer')->result_array();
    }

    public function getUserById($user_id) {
        $this->db->where('id', $user_id);
//        echo $this->db->last_query();
        return $this->db->get('customer')->result_array();
    }

//    public function updatePaymentLogByUserId($user_id, $data) {
//        $this->db->where('id', $id);
//        $this->db->update('customer', $data);
//    }

    public function updateFlyUpById($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('customer', $data);
    }

    public function getTreeLevel() {
        $sql = "SELECT count(`parent_id`) as cc ,parent_id
                FROM customer where parent_id > 0
                group by  `parent_id` ";
        return $this->db->query($sql)->result_array();
    }

    public function getFlyUpById($id) {
        $this->db->where('id', $id);
        return $this->db->get('customer')->result_array();
    }

    public function getParentByUserId($user_id) {
        $this->db->where('user_code', $user_id);
        return $this->db->get('customer')->result_array();
    }

    public function getProducts() {
        return $this->db->get('products')->result_array();
    }
    public function getProductByUserCode($user_code) {
        $this->db->where('user_code',$user_code);
        return $this->db->get('products_history')->result_array();
    }
    public function updateUserExpireDateByUserCode($user_code ,$data) {
         $this->db->where('user_code', $user_code);
        $this->db->update('customer', $data);
        
    }
    
    

    public function getUserTableCount($type, $filter_radio, $monthName, $startDate, $endDate, $user_code, $name) {
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('join_date >= ', $startDate);
            $this->db->where('join_date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $monthName != "" && $monthName != "all") {

            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $monthName . '"');
        }
        if ($type != "") {
            $this->db->where("type", $type);
            $this->db->where('user_code > 2');
        }
        if ($user_code != "") {
            $this->db->where("user_code", $user_code);
        }
        if ($name != "") {
            $this->db->where("name", $name);
        }
        return count($this->db->get('customer')->result_array());
    }

    public function getUserTablePage($limit, $start, $type, $filter_radio, $monthName, $startDate, $endDate, $user_code, $name) {
//        $this->db->where('user_id', $id);
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('DATE_FORMAT(  `join_date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `join_date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
        } else if ($filter_radio == "monthlyReport" && $monthName != "" && $monthName != "all") {

            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $monthName . '"');
        }
        if ($type != "") {
            $this->db->where("type", $type);
            $this->db->where('user_code > 2');
        }
        if ($user_code != "") {
            $this->db->where("user_code", $user_code);
        }
        if ($name != "") {
            $this->db->where("name", $name);
        }
        $this->db->limit($limit, $start);
        $this->db->order_by("id", "asc");
        $kk = $this->db->get('customer')->result_array();
//        echo $this->db->last_query();
//        exit;
        return $kk;
    }

    public function insertProducthistory($data) {
        $this->db->insert("products_history", $data);
    }

    public function insertSMS($data) {
        $this->db->insert("sms_log", $data);
    }

    public function get_user_by_userCode($user_code) {
        $this->db->where('user_code', $user_code);
        return $this->db->get('customer')->result_array();
    }

    public function update_user_key($user_code, $key) {
        $this->db->where('user_code', $user_code);
        $this->db->update('customer', array('data_key' => $key));
    }

}
