<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 5.1.6 or newer
 *
 * @package		CodeIgniter
 * @author		ExpressionEngine Dev Team
 * @copyright	Copyright (c) 2008 - 2011, EllisLab, Inc.
 * @license		http://codeigniter.com/user_guide/license.html
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
// ------------------------------------------------------------------------

/**
 * CodeIgniter Application Controller Class
 *
 * This class object is the super class that every library in
 * CodeIgniter will be assigned to.
 *
 * @package		CodeIgniter
 * @subpackage	Libraries
 * @category	Libraries
 * @author		ExpressionEngine Dev Team
 * @link		http://codeigniter.com/user_guide/general/controllers.html
 */
class CI_Controller {

    private static $instance;
    
    var $temp = 0;
    var $product_price ;
    var $profit;
    var $bonus;
    var $cor_charg = 300;
    var $renewal_amount ;
    var $renewal_profit="";
    var $flyUpId = 1;
    var $balance_type = array('transfer', 'direct', 'flyUP','renewal','paid','recived','signUp','bonus');
    var $reason_type = array('odd child', 'even child', 'expire', 'depth level', 'month even and master child is odd', 'month odd and master child is even', 'tree level end', 'month odd and master child is odd', 'month even and master child is even','basic And monthly');
    var $take_profit = array('yes' => 1, 'no' => 0);

    /**
     * Constructor
     */
    public function __construct() {
        self::$instance = & $this;

        // Assign all the class objects that were instantiated by the
        // bootstrap file (CodeIgniter.php) to local class variables
        // so that CI can run as one big super object.
        foreach (is_loaded() as $var => $class) {
            $this->$var = & load_class($class);
        }

        $this->load = & load_class('Loader', 'core');
        date_default_timezone_set('Asia/Karachi');
        $this->load->initialize();
        $this->load->library("session");
        log_message('debug', "Controller Class Initialized");
        $this->output->nocache();
    }

    public static function &get_instance() {
        return self::$instance;
    }

}

// END Controller class

/* End of file Controller.php */
/* Location: ./system/core/Controller.php */