<?php  global $themename, $input_prefix;

/*****************/
/* Theme Details */

$themename = "Casual";
$themeid = "casual";
$productid = "1450";
$presstrendsid = "n3kmyjata81hxzx01yv7trgzxiujuig0f";
/**********************/
/* Include OCMX files */
$include_folders = array("/ocmx/includes/", "/ocmx/theme-setup/", "/ocmx/widgets/", "/ocmx/front-end/", "/ajax/", "/ocmx/interface/");

include_once (TEMPLATEPATH."/ocmx/folder-class.php");
include_once (TEMPLATEPATH."/ocmx/load-includes.php");
include_once (TEMPLATEPATH."/ocmx/custom.php");


/* "Hook" up the OCMX */

update_option("ocmx_font_support", true);
add_action('init', 'ocmx_add_scripts');
add_action('after_setup_theme', 'ocmx_setup');

/***********************/
/* Add OCMX Menu Items */

function ocmx_add_admin() {
	global $wpdb;
	add_object_page("Theme Options", "Theme Options", "edit_theme_options", basename(__FILE__), '', 'http://obox-design.com/images/ocmx-favicon.png');	
	add_submenu_page(basename(__FILE__), "General Options", "General",  "edit_theme_options", basename(__FILE__), 'ocmx_general_options');
	add_submenu_page(basename(__FILE__), "Customize", "Customize", "edit_theme_options", "customize.php");
	add_submenu_page(basename(__FILE__), "Typography", "Typography",  "edit_theme_options", "ocmx-fonts", 'ocmx_font_options');
	add_submenu_page(basename(__FILE__), "Adverts", "Adverts",  "edit_theme_options",  "ocmx-adverts", 'ocmx_advert_options');
	add_submenu_page(basename(__FILE__), "Help", "Help", "edit_theme_options", "obox-help", 'ocmx_welcome_page');
	
};

add_action('admin_menu', 'ocmx_add_admin');

/*********************/
/* Load Localization */
load_theme_textdomain('ocmx', get_template_directory() . '/lang');

/*****************/
/* Add Nav Menus */

if (function_exists('register_nav_menus')) :
	register_nav_menus( array(
		'primary' => __('Primary Navigation', '$themename')
	) );
endif;

/***********************************************************************/
/* Set the parameters which allow the /interface/ folder to be included*/

function check_allow_ocmx(){
	return true;
}

/************************************************/
/* Fallback Function for WordPress Custom Menus */

function ocmx_fallback() {
	echo '<ul id="page_menu" class="page-menu clearfix">';
	wp_list_pages('title_li=&');
	echo '</ul>';
}

/**************************/
/* WP 3.4 Support         */
global $wp_version;
if ( version_compare( $wp_version, '3.4', '>=' ) ) 
	add_theme_support( 'custom-background' ); 
	add_theme_support( 'post-thumbnails' ); 
	add_theme_support( 'automatic-feed-links' ); 
	add_theme_support( 'menus' );
	add_theme_support( 'post-formats', array( 'aside', 'quote', 'link', 'image', 'video', 'audio') ); 

if ( ! isset( $content_width ) ) $content_width = 940;

/**************************/
/* Setup media */
function ocmx_setup_image_sizes() {
	add_image_size('940x530', 940, 530, true);
	add_image_size('460x260', 460, 260, true);
	add_image_size('510x290', 510, 290, true);
	add_image_size('300x170', 300, 170, true);
	add_image_size('325x270', 325, 270, true);
	add_image_size('220x125', 220, 125, true);
	add_image_size('140x140', 140, 140, true);
	add_image_size('50x50', 50, 50, true);
	add_image_size('250x100', 250, 100, true);
	add_image_size('180', 180);
	add_image_size('895', 895);
	add_image_size('500', 500);
	add_image_size('280', 280);
}
add_action( 'after_setup_theme', 'ocmx_setup_image_sizes' );

/******************************************************************************/
/* Each theme has their own "No Posts" styling, so it's kept in functions.php */

function ocmx_no_posts(){ ?>
	<li class="post transparent-container">					
    <div class="content clearfix">
        <h3 class="post-title"><a href="#"><?php _e("Page Not Found", "ocmx"); ?></a></h3>
        <div class="post-meta clearfix"></div>
        <div class="copy <?php echo $image_class; ?>">
             <?php _e("The page you are looking for does not exist", "ocmx"); ?>
        </div>
	</div>
</li>
<?php 
}

/**************************/
/* Facebook Support      */
function get_fbimage() {
  global $post;
  $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), '', '' );
  if ( has_post_thumbnail($post->ID) ) {
    $fbimage = $src[0];
  } else {
    global $post, $posts;
    $fbimage = '';
    $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i',
    $post->post_content, $matches);
    $fbimage = $matches [1] [0];
  }
  if(empty($fbimage)) {
    $fbimage = get_the_post_thumbnail($post->ID);
  }
  return $fbimage;
}