<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?> xmlns:og="http://ogp.me/ns/fb#" xmlns:og="http://opengraphprotocol.org/schema/" xmlns:addthis="http://www.addthis.com/help/api-spec">
<head profile="http://gmpg.org/xfn/11">
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<!--Set Viewport -->
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
<!--Get Obox SEO -->
<?php if(get_option("ocmx_seo") == "yes") {
	echo ocmx_site_title(); 
	echo ocmx_meta_description(); 
	echo ocmx_meta_keywords(); 
} else { ?>
<title>
<?php
	global $page, $paged;
	wp_title( '|', true, 'right' );
	bloginfo( 'name' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'ocmx' ), max( $paged, $page ) );
?>
</title>
<?php } ?>

<!-- Setup OpenGraph support-->
<?php if(is_home()) : ?>

<meta property="og:title" content="<?php bloginfo('name'); ?>"/>
<meta property="og:description" content="<?php bloginfo('description'); ?>"/>
<meta property="og:url" content="<?php echo home_url(); ?>"/>
<meta property="og:image" content="<?php echo get_fbimage(); ?>"/>
<meta property="og:type" content="<?php echo "website";?>"/>
<meta property="og:site_name" content="<?php bloginfo('name'); ?>"/>

<?php else : ?>
<meta property="og:title" content="<?php the_title(); ?>"/>
<meta property="og:description" content="<?php echo strip_tags($post->post_excerpt); ?>"/>
<meta property="og:url" content="<?php the_permalink(); ?>"/>
<meta property="og:image" content="<?php echo get_fbimage(); ?>"/>
<meta property="og:type" content="<?php echo "article"; ?>"/>
<meta property="og:site_name" content="<?php bloginfo('name'); ?>"/>

<?php endif; ?>
<!-- Begin Styling -->
<?php if(get_option("ocmx_custom_favicon") != "") : ?>
	<link href="<?php echo get_option("ocmx_custom_favicon"); ?>" rel="icon" type="image/png" />
<?php endif; ?>
<link href="<?php bloginfo('stylesheet_url'); ?>" rel="stylesheet" type="text/css" />
<link type="text/css" href="<?php echo home_url('/'); ?>?stylesheet=custom"rel="stylesheet" type="text/css" />
<link href="<?php bloginfo('template_directory'); ?>/ocmx/jplayer.css" rel="stylesheet" type="text/css" />
<link href="<?php bloginfo('template_directory'); ?>/jquery.lightbox-0.5.css" rel="stylesheet" type="text/css" />
<link href='http://fonts.googleapis.com/css?family=Droid+Sans+Mono' rel='stylesheet' type='text/css'>
<?php if(get_option("ocmx_rss_url")) : ?>
	<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php echo get_option("ocmx_rss_url"); ?>" />
<?php else : ?>
	<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<?php endif; ?>

<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<!--[if gte IE 7]> <script src="<?php bloginfo('template_directory'); ?>/scripts/DOMAssistantCompressed-2.7.4.js" type="text/javascript"></script> <script src="<?php bloginfo('template_directory'); ?>/scripts/ie-css3.js" type="text/javascript"></script> <![endif]-->

<?php wp_head(); ?>
</head>

<body <?php body_class(''); ?>>

<div id="header-container">
    <div id="header" class="clearfix">
        <div class="logo">
            <h1>
                <a href="<?php bloginfo('url'); ?>">
                    <?php if(get_option("ocmx_custom_logo")) : ?>
                        <img src="<?php echo get_option("ocmx_custom_logo"); ?>" alt="<?php bloginfo('name'); ?>" />
                    <?php else : ?>
                        <img src="<?php bloginfo('template_directory'); ?>/images/logo.png" alt="<?php strip_tags(bloginfo('name')); ?>" />
                    <?php endif; ?>
                </a>
            </h1>
        </div>
        <?php if (function_exists("wp_nav_menu")) :	
            wp_nav_menu(array(
                    'menu' => 'microinkdrop Menu',
                    'menu_id' => 'page_menu',
                    'menu_class' => 'page-menu clearfix',
                    'sort_column' 	=> 'menu_order',
                    'theme_location' => 'primary',
                    'container' => 'ul',
                    'fallback_cb' => 'ocmx_fallback')
            );
        endif; ?>
	</div>
</div>

<div id="content-container" class="clearfix">	